/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButtonContent;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniButton<M extends BasicButtonModel>
extends JComponent {
    public static final String BORDER_KEY_NORMAL = "dock.border.action.miniButton.normal";
    public static final String BORDER_KEY_NORMAL_SELECTED = "dock.border.action.miniButton.normal.selected";
    public static final String BORDER_KEY_MOUSE_OVER = "dock.border.action.miniButton.mouseOver";
    public static final String BORDER_KEY_MOUSE_OVER_SELECTED = "dock.border.action.miniButton.mouseOver.selected";
    public static final String BORDER_KEY_MOUSE_PRESSED = "dock.border.action.miniButton.mousePressed";
    public static final String BORDER_KEY_MOUSE_PRESSED_SELECTED = "dock.border.action.miniButton.mousePressed.selected";
    private MiniButtonContent content;
    private Border normalBorder;
    private Border mouseOverBorder;
    private Border mousePressedBorder;
    private Border normalSelectedBorder;
    private Border mouseOverSelectedBorder;
    private Border mousePressedSelectedBorder;
    private String borderKeyNormal = "dock.border.action.miniButton.normal";
    private String borderKeyMouseOver = "dock.border.action.miniButton.mouseOver";
    private String borderKeyMousePressed = "dock.border.action.miniButton.mousePressed";
    private String borderKeyNormalSelected = "dock.border.action.miniButton.normal.selected";
    private String borderKeyMouseOverSelected = "dock.border.action.miniButton.mouseOver.selected";
    private String borderKeyMousePressedSelected = "dock.border.action.miniButton.mousePressed.selected";
    private M model;
    private BasicButtonModelAdapter listener = new BasicButtonModelAdapter(){

        public void mouseInside(BasicButtonModel model, boolean mouseInside) {
            MiniButton.this.updateBorder();
        }

        public void mousePressed(BasicButtonModel model, boolean mousePressed) {
            if (mousePressed) {
                MiniButton.this.requestFocusInWindow();
            }
            MiniButton.this.updateBorder();
        }

        public void enabledStateChanged(BasicButtonModel model, boolean enabled) {
            MiniButton.this.updateBorder();
        }

        public void selectedStateChanged(BasicButtonModel model, boolean selected) {
            MiniButton.this.updateBorder();
        }

        public void borderChanged(BasicButtonModel model, String key, BorderModifier oldBorder, BorderModifier newBorder) {
            MiniButton.this.updateBorder();
        }
    };

    public MiniButton(M model) {
        this.model = model;
        this.content = this.createButtonContent();
        this.content.setModel((BasicButtonModel)model);
        this.setLayout(null);
        this.add(this.content);
        this.mousePressedBorder = BorderFactory.createBevelBorder(1);
        this.mouseOverBorder = BorderFactory.createBevelBorder(0);
        this.normalSelectedBorder = this.mousePressedBorder;
        this.mouseOverSelectedBorder = this.mousePressedBorder;
        this.mousePressedSelectedBorder = this.mouseOverBorder;
        this.setFocusable(true);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MiniButton.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                MiniButton.this.repaint();
            }
        });
        if (model != null) {
            this.content.setForegroundColorId("action.button.text", "action.button.text.disabled");
        }
    }

    protected MiniButtonContent createButtonContent() {
        return new MiniButtonContent();
    }

    protected MiniButtonContent getContent() {
        return this.content;
    }

    protected void setModel(M model) {
        if (this.model != null) {
            ((BasicButtonModel)this.model).removeListener(this.listener);
        }
        this.content.setModel((BasicButtonModel)model);
        this.model = model;
        if (this.model != null) {
            ((BasicButtonModel)this.model).addListener(this.listener);
            this.content.setForegroundColorId("action.button.text", "action.button.text.disabled");
        }
        this.updateBorder();
    }

    public M getModel() {
        return this.model;
    }

    public Border getMouseOverBorder() {
        return this.mouseOverBorder;
    }

    public void setMouseOverBorder(Border mouseOverBorder) {
        this.mouseOverBorder = mouseOverBorder;
        this.updateBorder();
    }

    public String getBorderKeyMouseOver() {
        return this.borderKeyMouseOver;
    }

    public void setBorderKeyMouseOver(String borderKeyMouseOver) {
        if (borderKeyMouseOver == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyMouseOver = borderKeyMouseOver;
        this.updateBorder();
    }

    public Border getMousePressedBorder() {
        return this.mousePressedBorder;
    }

    public void setMousePressedBorder(Border mousePressedBorder) {
        this.mousePressedBorder = mousePressedBorder;
        this.updateBorder();
    }

    public String getBorderKeyMousePressed() {
        return this.borderKeyMousePressed;
    }

    public void setBorderKeyMousePressed(String borderKeyMousePressed) {
        if (borderKeyMousePressed == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyMousePressed = borderKeyMousePressed;
        this.updateBorder();
    }

    public Border getNormalBorder() {
        return this.normalBorder;
    }

    public void setNormalBorder(Border normalBorder) {
        this.normalBorder = normalBorder;
        this.updateBorder();
    }

    public String getBorderKeyNormal() {
        return this.borderKeyNormal;
    }

    public void setBorderKeyNormal(String borderKeyNormal) {
        if (borderKeyNormal == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyNormal = borderKeyNormal;
        this.updateBorder();
    }

    public Border getNormalSelectedBorder() {
        return this.normalSelectedBorder;
    }

    public void setNormalSelectedBorder(Border normalSelectedBorder) {
        this.normalSelectedBorder = normalSelectedBorder;
        this.updateBorder();
    }

    public String getBorderKeyNormalSelected() {
        return this.borderKeyNormalSelected;
    }

    public void setBorderKeyNormalSelected(String borderKeyNormalSelected) {
        if (borderKeyNormalSelected == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyNormalSelected = borderKeyNormalSelected;
        this.updateBorder();
    }

    public Border getMouseOverSelectedBorder() {
        return this.mouseOverSelectedBorder;
    }

    public void setMouseOverSelectedBorder(Border mouseOverSelectedBorder) {
        this.mouseOverSelectedBorder = mouseOverSelectedBorder;
        this.updateBorder();
    }

    public String getBorderKeyMouseOverSelected() {
        return this.borderKeyMouseOverSelected;
    }

    public void setBorderKeyMouseOverSelected(String borderKeyMouseOverSelected) {
        if (borderKeyMouseOverSelected == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyMouseOverSelected = borderKeyMouseOverSelected;
        this.updateBorder();
    }

    public Border getMousePressedSelectedBorder() {
        return this.mousePressedSelectedBorder;
    }

    public void setMousePressedSelectedBorder(Border mousePressedSelectedBorder) {
        this.mousePressedSelectedBorder = mousePressedSelectedBorder;
        this.updateBorder();
    }

    public String getBorderKeyMousePressedSelected() {
        return this.borderKeyMousePressedSelected;
    }

    public void setBorderKeyMousePressedSelected(String borderKeyMousePressedSelected) {
        if (borderKeyMousePressedSelected == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.borderKeyMousePressedSelected = borderKeyMousePressedSelected;
        this.updateBorder();
    }

    @Override
    public void paint(Graphics g) {
        BackgroundPaint paint = ((BasicButtonModel)this.model).getBackground();
        BackgroundComponent component = ((BasicButtonModel)this.model).getBackgroundComponent();
        AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

            protected void background(Graphics g) {
            }

            protected void foreground(Graphics g) {
                MiniButton.this.doPaintForeground(g);
            }

            protected void border(Graphics g) {
                MiniButton.this.doPaintBorder(g);
            }

            protected void children(Graphics g) {
            }

            protected void overlay(Graphics g) {
            }

            public Transparency getTransparency() {
                return Transparency.DEFAULT;
            }
        };
        paintable.paint(g);
    }

    private void doPaintForeground(Graphics g) {
        this.paintContent(g);
        if (this.isFocusOwner() && this.isFocusable() && this.isEnabled()) {
            this.paintFocus(g);
        }
    }

    protected void paintContent(Graphics g) {
        this.paintChildren(g);
    }

    private void doPaintBorder(Graphics g) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintFocus(Graphics g) {
        g.setColor(this.getForeground());
        Insets insets = this.getMaxBorderInsets();
        int x = insets.left;
        int y = insets.right;
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        --h;
        g.drawLine(x, y, x + 2, y);
        g.drawLine(x, y + 1, x + 1, y + 1);
        g.drawLine(x, y + 2, x, y + 2);
        g.drawLine(x + --w, y, x + w - 2, y);
        g.drawLine(x + w, y + 1, x + w - 1, y + 1);
        g.drawLine(x + w, y + 2, x + w, y + 2);
        g.drawLine(x + w, y + h, x + w - 2, y + h);
        g.drawLine(x + w, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w, y + h - 2, x + w, y + h - 2);
        g.drawLine(x, y + h, x + 2, y + h);
        g.drawLine(x, y + h - 1, x + 1, y + h - 1);
        g.drawLine(x, y + h - 2, x, y + h - 2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets max = this.getMaxBorderInsets();
        Dimension size = this.content.getPreferredSize();
        size.width += max.left + max.right + 2;
        size.height += max.top + max.bottom + 2;
        return size;
    }

    @Override
    public void doLayout() {
        Insets insets = this.getMaxBorderInsets();
        this.content.setBounds(insets.left, insets.top, this.getWidth() - insets.right - insets.left, this.getHeight() - insets.top - insets.bottom);
    }

    protected Insets getMaxBorderInsets() {
        Insets max = new Insets(0, 0, 0, 0);
        for (int i = 0; i < 6; ++i) {
            Border border = null;
            switch (i) {
                case 0: {
                    border = this.getBorder(this.getNormalBorder(), this.borderKeyNormal);
                    break;
                }
                case 1: {
                    border = this.getBorder(this.getMouseOverBorder(), this.borderKeyMouseOver);
                    break;
                }
                case 2: {
                    border = this.getBorder(this.getMousePressedBorder(), this.borderKeyMousePressed);
                    break;
                }
                case 3: {
                    border = this.getBorder(this.getNormalSelectedBorder(), this.borderKeyNormalSelected);
                    break;
                }
                case 4: {
                    border = this.getBorder(this.getMouseOverSelectedBorder(), this.borderKeyMouseOverSelected);
                    break;
                }
                case 5: {
                    border = this.getBorder(this.getMousePressedSelectedBorder(), this.borderKeyMousePressedSelected);
                }
            }
            if (border == null) continue;
            Insets insets = border.getBorderInsets(this);
            max.left = Math.max(max.left, insets.left);
            max.right = Math.max(max.right, insets.right);
            max.top = Math.max(max.top, insets.top);
            max.bottom = Math.max(max.bottom, insets.bottom);
        }
        return max;
    }

    protected void updateBorder() {
        if (((BasicButtonModel)this.model).isEnabled() && ((BasicButtonModel)this.model).isMousePressed()) {
            if (((BasicButtonModel)this.model).isSelected()) {
                this.setBorder(this.getBorder(this.getMousePressedSelectedBorder(), this.borderKeyMousePressedSelected));
            } else {
                this.setBorder(this.getBorder(this.getMousePressedBorder(), this.borderKeyMousePressed));
            }
        } else if (((BasicButtonModel)this.model).isEnabled() && ((BasicButtonModel)this.model).isMouseInside()) {
            if (((BasicButtonModel)this.model).isSelected()) {
                this.setBorder(this.getBorder(this.getMouseOverSelectedBorder(), this.borderKeyMouseOverSelected));
            } else {
                this.setBorder(this.getBorder(this.getMouseOverBorder(), this.borderKeyMouseOver));
            }
        } else if (((BasicButtonModel)this.model).isSelected()) {
            this.setBorder(this.getBorder(this.getNormalSelectedBorder(), this.borderKeyNormalSelected));
        } else {
            this.setBorder(this.getBorder(this.getNormalBorder(), this.borderKeyNormal));
        }
    }

    private Border getBorder(Border defaultBorder, String key) {
        BorderModifier modifier = ((BasicButtonModel)this.model).getBorder(key);
        if (modifier == null) {
            return defaultBorder;
        }
        return modifier.modify(defaultBorder);
    }
}

