/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class TabDisplayerCombinerTarget
implements DisplayerCombinerTarget {
    private int index = -1;
    private DockableDisplayer displayer;
    private StackDockComponent stack;

    public TabDisplayerCombinerTarget(DockableDisplayer displayer, StackDockComponent stack, CombinerSource source, Enforcement force) {
        this.displayer = displayer;
        this.stack = stack;
        Point mouse = source.getMousePosition();
        if (mouse != null && stack != null && stack.getTabCount() == 1) {
            mouse = SwingUtilities.convertPoint(displayer.getDockable().getComponent(), mouse, stack.getComponent());
            Rectangle bounds = stack.getBoundsAt(0);
            if (stack.getDockTabPlacement().isHorizontal()) {
                if (bounds.y <= mouse.y && bounds.y + bounds.height >= mouse.y) {
                    this.index = bounds.x + bounds.width / 2 < mouse.x ? 1 : 0;
                } else if (force.getForce() > 0.9f) {
                    this.index = 1;
                }
            } else if (bounds.x <= mouse.x && bounds.x + bounds.width >= mouse.x) {
                this.index = bounds.y + bounds.height / 2 < mouse.y ? 1 : 0;
            } else if (force.getForce() > 0.9f) {
                this.index = 1;
            }
        }
    }

    public boolean isValid() {
        return this.index >= 0;
    }

    public int getIndex() {
        return this.index;
    }

    public Dockable getTarget() {
        return this.displayer.getDockable();
    }

    public Dockable execute(CombinerSource source) {
        DockStation parent = source.getParent();
        PlaceholderMap placeholders = source.getPlaceholders();
        StackDockStation stack = new StackDockStation(parent.getTheme());
        stack.setController(parent.getController());
        if (placeholders != null) {
            stack.setPlaceholders(placeholders);
        }
        if (this.index == 1) {
            stack.drop(source.getOld(), false);
            stack.drop(source.getNew(), false);
        } else {
            stack.drop(source.getNew(), false);
            stack.drop(source.getOld(), false);
        }
        return stack;
    }

    public void paint(Graphics g, Component component, StationPaint paint, Rectangle stationBounds, Rectangle dockableBounds) {
        dockableBounds = new Rectangle(dockableBounds);
        Rectangle tab = this.stack.getBoundsAt(0);
        Point zero = new Point(0, 0);
        zero = SwingUtilities.convertPoint(this.stack.getComponent(), zero, component);
        tab.x += zero.x;
        tab.y += zero.y;
        int delta = 0;
        switch (this.stack.getDockTabPlacement()) {
            case TOP_OF_DOCKABLE: {
                delta = tab.y + tab.height - dockableBounds.y;
                if (delta <= 0) break;
                dockableBounds.height -= delta;
                dockableBounds.y += delta;
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                delta = dockableBounds.y + dockableBounds.height - tab.y;
                if (delta <= 0) break;
                dockableBounds.height -= delta;
                break;
            }
            case LEFT_OF_DOCKABLE: {
                delta = tab.x + tab.width - dockableBounds.x;
                if (delta <= 0) break;
                dockableBounds.width -= delta;
                dockableBounds.x += delta;
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                delta = dockableBounds.x + dockableBounds.width - tab.x;
                if (delta <= 0) break;
                dockableBounds.width -= delta;
            }
        }
        paint.drawInsertion(g, this.displayer.getStation(), stationBounds, dockableBounds);
        if (this.stack.getDockTabPlacement().isHorizontal()) {
            if (this.index == 0) {
                paint.drawInsertionLine(g, this.displayer.getStation(), tab.x, tab.y, tab.x, tab.y + tab.height);
            } else {
                paint.drawInsertionLine(g, this.displayer.getStation(), tab.x + tab.width, tab.y, tab.x + tab.width, tab.y + tab.height);
            }
        } else if (this.index == 0) {
            paint.drawInsertionLine(g, this.displayer.getStation(), tab.x, tab.y, tab.x + tab.width, tab.y);
        } else {
            paint.drawInsertionLine(g, this.displayer.getStation(), tab.x, tab.y + tab.height, tab.x + tab.width, tab.y + tab.height);
        }
    }

    public void paint(Graphics g, StationPaint paint) {
        Dockable dockable = this.displayer.getDockable();
        Point zeroDockable = new Point(0, 0);
        SwingUtilities.convertPoint(this.displayer.getComponent(), zeroDockable, dockable.getComponent());
        paint.drawInsertion(g, this.displayer.getStation(), null, new Rectangle(zeroDockable, dockable.getComponent().getSize()));
    }
}

