/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableDockableMenuPiece
extends BaseMenuPiece {
    private DockFrontend frontend;
    private Map<Dockable, Item> items = new HashMap<Dockable, Item>();
    private DockableCollector collector = new DockableCollector();
    private Comparator<String> order = new Comparator<String>(){
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(String o1, String o2) {
            return this.collator.compare(o1, o2);
        }
    };
    private AtomicInteger orderCommand = new AtomicInteger(0);

    public CloseableDockableMenuPiece() {
    }

    public CloseableDockableMenuPiece(DockFrontend frontend) {
        this.setFrontend(frontend);
    }

    public void setOrder(Comparator<String> order) {
        this.order = order;
        this.reorder();
    }

    public Comparator<String> getOrder() {
        return this.order;
    }

    protected void reorder() {
        final int identifier = this.orderCommand.incrementAndGet();
        if (EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    CloseableDockableMenuPiece.this.order(identifier);
                }
            });
        } else {
            this.order(identifier);
        }
    }

    private void order(int identifier) {
        if (identifier == this.orderCommand.get() && this.order != null) {
            Item[] items = this.items.values().toArray(new Item[this.items.size()]);
            Arrays.sort(items, new Comparator<Item>(){

                @Override
                public int compare(Item o1, Item o2) {
                    return CloseableDockableMenuPiece.this.order.compare(o1.getText(), o2.getText());
                }
            });
            this.removeAll();
            for (Item item : items) {
                this.add(item);
            }
        }
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public void setFrontend(DockFrontend frontend) {
        if (this.frontend != frontend) {
            if (this.isBound() && this.frontend != null) {
                this.frontend.removeFrontendListener(this.collector);
                for (Item item : this.items.values()) {
                    item.destroy();
                    this.remove(item);
                }
                this.items.clear();
            }
            this.frontend = frontend;
            if (this.isBound() && this.frontend != null) {
                this.frontend.addFrontendListener(this.collector);
                for (Dockable dockable : this.frontend.listDockables()) {
                    this.collector.added(frontend, dockable);
                }
            }
        }
    }

    @Override
    public void bind() {
        if (!this.isBound()) {
            super.bind();
            if (this.frontend != null) {
                this.frontend.addFrontendListener(this.collector);
                for (Dockable dockable : this.frontend.listDockables()) {
                    this.collector.added(this.frontend, dockable);
                }
            }
        }
    }

    @Override
    public void unbind() {
        if (this.isBound()) {
            super.unbind();
            if (this.frontend != null) {
                this.frontend.removeFrontendListener(this.collector);
                for (Item item : this.items.values()) {
                    item.destroy();
                    this.remove(item);
                }
                this.items.clear();
            }
        }
    }

    protected Item create(Dockable dockable) {
        return new Item(dockable);
    }

    protected void insert(Item item) {
        this.add(item);
        this.reorder();
    }

    protected void show(Dockable dockable) {
        this.frontend.show(dockable);
    }

    protected void hide(Dockable dockable) {
        this.frontend.hide(dockable);
    }

    protected boolean include(Dockable dockable) {
        return this.frontend.isHideable(dockable);
    }

    public void check(Dockable dockable) {
        if (this.include(dockable)) {
            if (!this.items.containsKey(dockable)) {
                this.collector.added(this.frontend, dockable);
            }
        } else if (this.items.containsKey(dockable)) {
            this.collector.removed(this.frontend, dockable);
        }
    }

    protected class Item
    extends JCheckBoxMenuItem
    implements DockableListener,
    ActionListener {
        private Dockable dockable;
        private boolean onChange = false;

        public Item(Dockable dockable) {
            this.dockable = dockable;
            dockable.addDockableListener(this);
            this.addActionListener(this);
            this.setIcon(dockable.getTitleIcon());
            this.setText(dockable.getTitleText());
        }

        public void setDockableState(boolean visible) {
            try {
                this.onChange = true;
                this.setSelected(visible);
            }
            finally {
                this.onChange = false;
            }
        }

        public void destroy() {
            this.dockable.removeDockableListener(this);
            this.removeActionListener(this);
            this.setIcon(null);
            this.setText("");
        }

        public void titleBound(Dockable dockable, DockTitle title) {
        }

        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            this.setIcon(newIcon);
        }

        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            this.setText(newTitle);
            CloseableDockableMenuPiece.this.reorder();
        }

        public void titleToolTipChanged(Dockable dockable, String oldToolTip, String newToolTip) {
        }

        public void titleUnbound(Dockable dockable, DockTitle title) {
        }

        public void titleExchanged(Dockable dockable, DockTitle title) {
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.onChange) {
                if (this.isSelected()) {
                    CloseableDockableMenuPiece.this.show(this.dockable);
                } else {
                    CloseableDockableMenuPiece.this.hide(this.dockable);
                }
            }
        }
    }

    private class DockableCollector
    extends DockFrontendAdapter {
        private DockableCollector() {
        }

        public void hidden(DockFrontend fronend, Dockable dockable) {
            Item item = (Item)CloseableDockableMenuPiece.this.items.get(dockable);
            if (item != null) {
                item.setDockableState(false);
            }
        }

        public void shown(DockFrontend frontend, Dockable dockable) {
            Item item = (Item)CloseableDockableMenuPiece.this.items.get(dockable);
            if (item != null) {
                item.setDockableState(true);
            }
        }

        public void added(DockFrontend frontend, Dockable dockable) {
            if (CloseableDockableMenuPiece.this.include(dockable)) {
                Item item = CloseableDockableMenuPiece.this.create(dockable);
                item.setDockableState(frontend.isShown(dockable));
                CloseableDockableMenuPiece.this.items.put(dockable, item);
                CloseableDockableMenuPiece.this.insert(item);
            }
        }

        public void removed(DockFrontend frontend, Dockable dockable) {
            Item item = (Item)CloseableDockableMenuPiece.this.items.remove(dockable);
            if (item != null) {
                item.destroy();
                CloseableDockableMenuPiece.this.remove(item);
            }
        }

        public void hideable(DockFrontend frontend, Dockable dockable, boolean hideable) {
            CloseableDockableMenuPiece.this.check(dockable);
        }
    }
}

