/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.dockable.TrueMovingImage;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.AWTComponentCaptureStrategy;
import bibliothek.gui.dock.util.DockSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ScreencaptureMovingImageFactory
implements DockableMovingImageFactory {
    private Dimension max;
    private float alpha;

    public ScreencaptureMovingImageFactory(Dimension max) {
        this(max, 1.0f);
    }

    public ScreencaptureMovingImageFactory(Dimension max, float alpha) {
        this.max = max;
        this.setAlpha(alpha);
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f || Float.isNaN(alpha)) {
            throw new IllegalArgumentException("alpha must be between 0 and 1");
        }
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public MovingImage create(DockController controller, DockTitle snatched) {
        return this.create(controller, snatched.getDockable());
    }

    public MovingImage create(DockController controller, Dockable dockable) {
        BufferedImage image = this.createImageFrom(controller, dockable);
        TrueMovingImage moving = new TrueMovingImage();
        moving.setAlpha(this.alpha);
        moving.setImage(image);
        return moving;
    }

    public BufferedImage createImageFrom(DockController controller, Dockable dockable) {
        Component c2 = dockable.getComponent();
        BufferedImage image = this.createImageFrom(controller, c2);
        if (image == null) {
            Icon icon = dockable.getTitleIcon();
            if (icon == null || icon.getIconHeight() < 1 || icon.getIconWidth() < 1) {
                return null;
            }
            image = new BufferedImage(icon.getIconWidth() + 2, icon.getIconHeight() + 2, 2);
            Graphics2D g = image.createGraphics();
            g.setColor(c2.getBackground());
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            icon.paintIcon(c2, g, 1, 1);
            g.dispose();
        }
        return image;
    }

    public BufferedImage createImageFrom(DockController controller, Component c2) {
        Dimension size = new Dimension(Math.max(1, c2.getWidth()), Math.max(1, c2.getHeight()));
        BufferedImage image = null;
        if (size.width >= 10 && size.height >= 10) {
            if (DockSwingUtilities.containsAWTComponents(c2)) {
                image = controller.getProperties().get(AWTComponentCaptureStrategy.STRATEGY).createCapture(controller, c2);
            } else {
                image = new BufferedImage(size.width, size.height, 2);
                Graphics2D g = image.createGraphics();
                c2.paint(g);
                g.dispose();
            }
            if (image != null) {
                double factor = 1.0;
                if (this.max != null) {
                    factor = Math.min(this.max.getWidth() / size.getWidth(), this.max.getHeight() / size.getHeight());
                }
                if (factor < 1.0) {
                    int w = (int)(factor * size.getWidth());
                    int h = (int)(factor * size.getHeight());
                    w = Math.max(w, 1);
                    h = Math.max(h, 1);
                    if (w != size.width || h != size.height) {
                        BufferedImage small = new BufferedImage(w, h, image.getType());
                        Graphics2D g = small.createGraphics();
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.drawImage(image, 0, 0, w, h, 0, 0, size.width, size.height, null);
                        g.dispose();
                        image = small;
                    }
                }
            }
        }
        return image;
    }
}

