/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.focus.EnsuringFocusRequest;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.control.focus.RepeatingFocusRequest;
import bibliothek.gui.dock.event.FocusVetoListener;
import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class DefaultFocusRequest
implements FocusRequest {
    private DockElementRepresentative source;
    private Component component;
    private boolean force;
    private boolean ensureFocusSet;
    private boolean ensureDockableFocused;
    private boolean hardRequest;
    private FocusVetoListener.FocusVeto veto;
    private DockController controller;

    public DefaultFocusRequest(DockElementRepresentative source, boolean force) {
        this(source, null, force);
    }

    public DefaultFocusRequest(DockElementRepresentative source, Component component, boolean force) {
        this(source, component, force, true, false);
    }

    public DefaultFocusRequest(DockElementRepresentative source, Component component, boolean force, boolean ensureFocusSet, boolean ensureDockableFocused) {
        this(source, component, force, ensureFocusSet, ensureDockableFocused, false);
    }

    public DefaultFocusRequest(DockElementRepresentative source, Component component, boolean force, boolean ensureFocusSet, boolean ensureDockableFocused, boolean hardRequest) {
        this.source = source;
        this.component = component;
        this.force = force;
        this.ensureFocusSet = ensureFocusSet;
        this.ensureDockableFocused = ensureDockableFocused;
        this.hardRequest = hardRequest;
    }

    public DockElementRepresentative getSource() {
        return this.source;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getDelay() {
        return 0;
    }

    public boolean isHardRequest() {
        return this.hardRequest;
    }

    public boolean acceptable(Component component) {
        Dockable dockable = this.getDockable();
        if (this.ensureDockableFocused && dockable != null) {
            return SwingUtilities.isDescendingFrom(component, dockable.getComponent());
        }
        return true;
    }

    public boolean validate(FocusController controller) {
        this.controller = controller.getController();
        if (this.force) {
            return true;
        }
        return controller.getFocusedDockable() != this.getDockable();
    }

    private Dockable getDockable() {
        if (this.source == null) {
            return null;
        }
        return this.source.getElement().asDockable();
    }

    public void veto(FocusVetoListener.FocusVeto veto) {
        this.veto = veto;
    }

    public FocusVetoListener.FocusVeto getVeto() {
        return this.veto;
    }

    public FocusRequest grant(Component component) {
        Window root;
        Dockable dockable = this.getDockable();
        if (dockable != null && (this.ensureFocusSet || this.ensureDockableFocused)) {
            return new EnsuringFocusRequest(dockable, this.ensureDockableFocused, component);
        }
        if (component == null && this.controller != null && (root = this.controller.getRootWindowProvider().searchWindow()) != null) {
            return new RepeatingFocusRequest(null, root, this.isHardRequest());
        }
        return null;
    }
}

