/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SharingSelectableDockAction;
import bibliothek.gui.dock.action.actions.SimpleDropDownItemAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleSelectableAction
extends SimpleDropDownItemAction
implements SharingSelectableDockAction,
SelectableDockAction {
    private List<SelectableDockActionListener> listeners = new ArrayList<SelectableDockActionListener>();
    private boolean selected = false;
    private Map<ActionContentModifier, Icon> selectIcons = new HashMap<ActionContentModifier, Icon>();
    private ActionType<SelectableDockAction> type;

    public SimpleSelectableAction(ActionType<SelectableDockAction> type, boolean monitorDisabling) {
        super(monitorDisabling);
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type = type;
    }

    @Override
    public <V> V createView(ViewTarget<V> target, ActionViewConverter converter, Dockable dockable) {
        return converter.createView(this.type, this, target, dockable);
    }

    @Override
    public void addSelectableListener(SelectableDockActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSelectableListener(SelectableDockActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSelectedChanged() {
        Set<Dockable> dockables = this.getBoundDockables();
        for (SelectableDockActionListener listener : this.listeners.toArray(new SelectableDockActionListener[this.listeners.size()])) {
            listener.selectedChanged(this, dockables);
        }
    }

    @Override
    public boolean isSelected(Dockable dockable) {
        return this.selected;
    }

    @Override
    public void setSelected(Dockable dockable, boolean selected) {
        this.setSelected(selected);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected != this.selected) {
            this.selected = selected;
            this.fireSelectedChanged();
            this.fireActionIconChanged(null, this.getBoundDockables());
        }
    }

    @Override
    public Icon getIcon(Dockable dockable, ActionContentModifier modifier) {
        if (this.isSelected()) {
            return this.firstNonNull(this.selectIcons.get(modifier), super.getIcon(dockable, modifier));
        }
        return super.getIcon(dockable, modifier);
    }

    protected Icon firstNonNull(Icon ... icons) {
        for (Icon icon : icons) {
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @Override
    public ActionContentModifier[] getIconContexts(Dockable dockable) {
        HashSet<ActionContentModifier> result = new HashSet<ActionContentModifier>();
        for (ActionContentModifier modifier : super.getIconContexts(dockable)) {
            result.add(modifier);
        }
        result.addAll(this.selectIcons.keySet());
        return result.toArray(new ActionContentModifier[result.size()]);
    }

    public void setSelectedIcon(Icon icon) {
        this.setSelectedIcon(ActionContentModifier.NONE, icon);
    }

    public Icon getSelectedIcon() {
        return this.getSelectedIcon(ActionContentModifier.NONE);
    }

    public void setDisabledSelectedIcon(Icon icon) {
        this.setSelectedIcon(ActionContentModifier.DISABLED, icon);
    }

    public Icon getDisabledSelectedIcon() {
        return this.getSelectedIcon(ActionContentModifier.DISABLED);
    }

    @Override
    public Icon getSelectedIcon(ActionContentModifier modifier) {
        return this.selectIcons.get(modifier);
    }

    @Override
    public void setSelectedIcon(ActionContentModifier modifier, Icon selectedIcon) {
        if (selectedIcon == null) {
            this.selectIcons.remove(modifier);
        } else {
            this.selectIcons.put(modifier, selectedIcon);
        }
        this.fireActionIconChanged(modifier, this.getBoundDockables());
    }

    public static class Radio
    extends SimpleSelectableAction {
        public Radio() {
            this(true);
        }

        public Radio(boolean monitorDisabling) {
            super(ActionType.RADIO, monitorDisabling);
            this.setDropDownTriggerableSelected(false);
        }

        public boolean trigger(Dockable dockable) {
            if (!this.isEnabled(dockable) || this.isSelected(dockable)) {
                return false;
            }
            this.setSelected(dockable, true);
            return true;
        }
    }

    public static class Check
    extends SimpleSelectableAction {
        public Check() {
            this(true);
        }

        public Check(boolean monitorDisabling) {
            super(ActionType.CHECK, monitorDisabling);
            this.setDropDownSelectable(false);
        }

        public boolean trigger(Dockable dockable) {
            if (!this.isEnabled(dockable)) {
                return false;
            }
            this.setSelected(dockable, !this.isSelected(dockable));
            return true;
        }
    }
}

