/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import bibliothek.extension.gui.dock.theme.smooth.SmoothChanger;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.basic.BasicButtonDockTitle;
import bibliothek.gui.dock.title.DockTitleEvent;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Container;

public class SmoothDefaultButtonTitle
extends BasicButtonDockTitle {
    private final int ACTIVE_STATE = 0;
    private final int SELECTED_STATE = 1;
    private final int INACTIVE_STATE = 2;
    private int[] current;
    private SmoothChanger changer = new SmoothChanger(3){

        protected int destination() {
            if (SmoothDefaultButtonTitle.this.isActive()) {
                return 0;
            }
            if (SmoothDefaultButtonTitle.this.isSelected()) {
                return 1;
            }
            return 2;
        }

        protected void repaint(int[] current) {
            SmoothDefaultButtonTitle.access$002(SmoothDefaultButtonTitle.this, (int[])current.clone());
            SmoothDefaultButtonTitle.this.updateColors();
        }
    };

    public SmoothDefaultButtonTitle(Dockable dockable, DockTitleVersion origin) {
        super(dockable, origin);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    public void changed(DockTitleEvent event) {
        super.changed(event);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    protected void updateColors() {
        this.updateForegroundColor();
        this.updateBackgroundColor();
    }

    protected void updateForegroundColor() {
        if (this.changer != null && this.changer.isRunning() && this.current != null) {
            this.setForeground(this.triColor(this.foreground(this.getActiveTextColor()), this.foreground(this.getSelectedTextColor()), this.foreground(this.getInactiveTextColor())));
        } else if (this.isActive()) {
            this.setForeground(this.getActiveTextColor());
        } else if (this.isSelected()) {
            this.setForeground(this.getSelectedTextColor());
        } else {
            this.setForeground(this.getInactiveTextColor());
        }
    }

    protected void updateBackgroundColor() {
        if (this.changer != null && this.changer.isRunning() && this.current != null) {
            this.setBackground(this.triColor(this.background(this.getActiveColor()), this.background(this.getSelectedColor()), this.background(this.getInactiveColor())));
        } else if (this.isActive()) {
            this.setBackground(this.getActiveColor());
        } else if (this.isSelected()) {
            this.setBackground(this.getSelectedColor());
        } else {
            this.setBackground(this.getInactiveColor());
        }
    }

    private Color triColor(Color a, Color b, Color c2) {
        int sum = 0;
        for (int count : this.current) {
            sum += count;
        }
        if (sum == 0) {
            return Color.BLACK;
        }
        double factorA = (double)this.current[0] / (double)sum;
        double factorB = (double)this.current[1] / (double)sum;
        double factorC = (double)this.current[2] / (double)sum;
        double red = factorA * (double)a.getRed() + factorB * (double)b.getRed() + factorC * (double)c2.getRed();
        double green = factorA * (double)a.getGreen() + factorB * (double)b.getGreen() + factorC * (double)c2.getGreen();
        double blue = factorA * (double)a.getBlue() + factorB * (double)b.getBlue() + factorC * (double)c2.getBlue();
        return new Color(Math.max(0, Math.min(255, (int)red)), Math.max(0, Math.min(255, (int)green)), Math.max(0, Math.min(255, (int)blue)));
    }

    private Color foreground(Color set) {
        if (set != null) {
            return set;
        }
        Container parent = this.getParent();
        if (parent == null) {
            return Color.BLACK;
        }
        set = parent.getForeground();
        if (set != null) {
            return set;
        }
        return Color.BLACK;
    }

    private Color background(Color set) {
        if (set != null) {
            return set;
        }
        Container parent = this.getParent();
        if (parent == null) {
            return Color.WHITE;
        }
        set = parent.getBackground();
        if (set != null) {
            return set;
        }
        return Color.WHITE;
    }

    static /* synthetic */ int[] access$002(SmoothDefaultButtonTitle x0, int[] x1) {
        x0.current = x1;
        return x1;
    }
}

