/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import java.awt.Dimension;
import java.util.Arrays;

public class Arch {
    private int width;
    private int height;
    private int[] values;

    public Arch(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("width or height smaller than 1: " + width + ", " + height);
        }
        this.width = width;
        this.height = height;
        this.values = new int[width];
        this.calculate();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getValue(int x) {
        return this.values[x];
    }

    private void calculate() {
        int x;
        int y;
        int x2;
        int lineWidth = this.lineWidth(this.width);
        int lineHeight = this.lineHeight(this.height);
        Dimension line = this.findGoodSlope(lineWidth, lineHeight);
        lineWidth = line.width;
        lineHeight = line.height;
        int topArchWidth = (this.width - lineWidth) / 2;
        int topArchHeight = (this.height - lineHeight) / 2;
        int bottomArchWidth = this.width - topArchWidth - lineWidth;
        int bottomArchHeight = this.height - topArchHeight - lineHeight;
        Arrays.fill(this.values, -1);
        double[] topArch = this.arch(0, 0, topArchWidth, topArchHeight, (double)lineHeight / (double)lineWidth);
        double[] bottomArch = this.arch(0, 0, bottomArchWidth, bottomArchHeight, (double)lineHeight / (double)lineWidth);
        for (x2 = 0; x2 < topArchWidth; ++x2) {
            this.values[x2] = y = (int)(topArch[x2] + 0.5);
        }
        for (x2 = 0; x2 < bottomArchWidth; ++x2) {
            y = (int)(bottomArch[x2] + 0.5);
            this.values[this.width - x2 - 1] = this.height - y - 1;
        }
        double[] sample = this.line(topArchWidth, topArchHeight, this.width - bottomArchWidth, this.height - bottomArchHeight);
        for (x = 0; x < sample.length && x + topArchWidth < this.values.length; ++x) {
            int y2;
            this.values[x + topArchWidth] = y2 = (int)(sample[x] + 0.5);
        }
        if (this.values[0] == -1) {
            this.values[0] = 0;
            this.values[this.values.length - 1] = this.height - 1;
        }
        int n = this.width / 2;
        for (x = 1; x <= n; ++x) {
            if (this.values[x] != -1) continue;
            this.values[x] = this.values[x - 1];
            this.values[this.width - x - 1] = this.values[this.width - x];
        }
    }

    private double[] line(int x1, int y1, int x2, int y2) {
        double[] sample = new double[x2 - x1 + 1];
        for (int t = 0; t < sample.length; ++t) {
            for (int t2 = 0; t2 < 10; ++t2) {
                double xvalue = (double)(10 * t + t2) / 10.0 / (double)sample.length;
                double yvalue = (double)(10 * t + t2) / 10.0 / (double)(sample.length + 1);
                double bx = (double)x1 + xvalue * (double)(x2 - x1 + 1);
                double by = (double)y1 + yvalue * (double)(y2 - y1 + 1);
                int n = (int)bx - x1;
                sample[n] = sample[n] + 0.1 * by;
            }
        }
        return sample;
    }

    private double[] arch(int x, int y, int width, int height, double slope) {
        double cutLine = y;
        double cutX = this.cutWithZero(x + width, y + height, slope, cutLine);
        double cutY = cutLine;
        double[] sample = new double[width];
        int[] sampleCount = new int[width];
        for (int t = 0; t < width; ++t) {
            for (int t2 = 0; t2 < 10; ++t2) {
                double value = (double)(10 * t + t2) / 10.0 / (double)width;
                double bx = this.bezier(value, x, cutX, x + width);
                double by = this.bezier(value, y, cutY, y + height);
                int index = (int)bx - x;
                int count = sampleCount[index];
                int n = index;
                sampleCount[n] = sampleCount[n] + 1;
                sample[index] = ((double)count * sample[index] + by) / (double)(count + 1);
            }
        }
        return sample;
    }

    private double bezier(double t, double p0, double p1, double p2) {
        return (1.0 - t) * (1.0 - t) * p0 + 2.0 * t * (1.0 - t) * p1 + t * t * p2;
    }

    private double cutWithZero(double x, double y, double m, double line) {
        double c2 = y - m * x;
        return (line - c2) / m;
    }

    private int lineWidth(int width) {
        int line = width / 3;
        int mod = width % 3;
        if (mod == 1) {
            return line + 1;
        }
        return line;
    }

    private int lineHeight(int height) {
        int line = height / 2;
        if ((height - line) % 2 == 1) {
            ++line;
        }
        return line;
    }

    private Dimension findGoodSlope(int lineWidth, int lineHeight) {
        Dimension result = new Dimension(lineWidth, lineHeight);
        if (lineHeight > 0) {
            double ratio = (double)lineWidth / (double)lineHeight;
            double nearest = this.neareastRatio(ratio);
            result.width = (int)(nearest * (double)lineHeight);
        }
        return result;
    }

    private double neareastRatio(double ratio) {
        if (ratio > 1.0) {
            return Math.round(ratio);
        }
        return 1.0 / (double)Math.round(1.0 / ratio);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int y = 0; y < this.height; ++y) {
            if (y > 0) {
                builder.append("\n");
            }
            if (y < 10) {
                builder.append(" ");
            }
            builder.append(y);
            builder.append(": ");
            for (int x = 0; x < this.width; ++x) {
                if (this.values[x] == y) {
                    builder.append("*");
                    continue;
                }
                builder.append(" ");
            }
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Arch other = (Arch)obj;
        if (this.height != other.height) {
            return false;
        }
        return this.width == other.width;
    }
}

