/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.eclipse.rex.RexSystemColor;
import bibliothek.gui.DockController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class RectEclipseBorder
implements Border {
    private boolean fillEdges;
    private DockController controller;
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 4;
    public static final int BOTTOM_RIGHT = 8;
    private int roundEdges;

    public RectEclipseBorder(DockController controller, boolean fillEdges) {
        this(controller, fillEdges, 3);
    }

    public RectEclipseBorder(DockController controller, boolean fillEdges, int roundEdges) {
        this.controller = controller;
        this.fillEdges = fillEdges;
    }

    public void setRoundEdges(int roundEdges) {
        this.roundEdges = roundEdges;
    }

    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        Color color;
        if (this.fillEdges) {
            g.setColor(c2.getBackground());
            if ((this.roundEdges & 1) != 0) {
                g.drawLine(0, 0, 1, 0);
                g.drawLine(0, 1, 0, 1);
            }
            if ((this.roundEdges & 2) != 0) {
                g.drawLine(width - 2, 0, width - 1, 0);
                g.drawLine(width - 1, 1, width - 1, 1);
            }
            if ((this.roundEdges & 4) != 0) {
                g.drawLine(0, height - 1, 1, height - 1);
                g.drawLine(0, height - 2, 0, height - 2);
            }
            if ((this.roundEdges & 8) != 0) {
                g.drawLine(width - 2, height - 1, width - 1, height - 1);
                g.drawLine(width - 1, height - 2, width - 1, height - 2);
            }
        }
        if ((color = (Color)this.controller.getColors().get("stack.border")) == null) {
            color = RexSystemColor.getBorderColor();
        }
        g.setColor(color);
        if ((this.roundEdges & 1) != 0) {
            g.drawLine(1, 1, 1, 1);
        } else {
            g.drawLine(0, 0, 1, 0);
            g.drawLine(0, 1, 0, 1);
        }
        if ((this.roundEdges & 2) != 0) {
            g.drawLine(width - 2, 1, width - 2, 1);
        } else {
            g.drawLine(width - 2, 0, width - 1, 0);
            g.drawLine(width - 1, 1, width - 1, 1);
        }
        if ((this.roundEdges & 4) != 0) {
            g.drawLine(1, height - 2, 1, height - 2);
        } else {
            g.drawLine(0, height - 2, 0, height - 1);
            g.drawLine(1, height - 1, 1, height - 1);
        }
        if ((this.roundEdges & 8) != 0) {
            g.drawLine(width - 2, height - 2, width - 2, height - 2);
        } else {
            g.drawLine(width - 1, height - 2, width - 1, height - 1);
            g.drawLine(width - 2, height - 1, width - 2, height - 1);
        }
        g.drawLine(2, 0, width - 3, 0);
        g.drawLine(0, 2, 0, height - 3);
        g.drawLine(width - 1, 2, width - 1, height - 3);
        g.drawLine(2, height - 1, width - 3, height - 1);
    }

    public Insets getBorderInsets(Component c2) {
        return new Insets(1, 1, 1, 1);
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

