/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.CSVWriteProc;
import au.com.bytecode.opencsv.ResultSetHelper;
import au.com.bytecode.opencsv.ResultSetHelperService;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class CSVWriter
implements Closeable {
    public static final int INITIAL_STRING_SIZE = 128;
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    private ResultSetHelper resultService = new ResultSetHelperService();

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char c2) {
        this(writer, c2, '\"');
    }

    public CSVWriter(Writer writer, char c2, char c3) {
        this(writer, c2, c3, '\"');
    }

    public CSVWriter(Writer writer, char c2, char c3, char c4) {
        this(writer, c2, c3, c4, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char c2, char c3, String string) {
        this(writer, c2, c3, '\"', string);
    }

    public CSVWriter(Writer writer, char c2, char c3, char c4, String string) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = c2;
        this.quotechar = c3;
        this.escapechar = c4;
        this.lineEnd = string;
    }

    public void writeAll(List<String[]> list) {
        for (String[] stringArray : list) {
            this.writeNext(stringArray);
        }
    }

    protected void writeColumnNames(ResultSet resultSet) throws SQLException {
        this.writeNext(this.resultService.getColumnNames(resultSet));
    }

    public void writeAll(ResultSet resultSet, boolean bl) throws SQLException, IOException {
        if (bl) {
            this.writeColumnNames(resultSet);
        }
        while (resultSet.next()) {
            this.writeNext(this.resultService.getColumnValues(resultSet));
        }
    }

    public void writeNext(String ... stringArray) {
        if (stringArray == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i != 0) {
                stringBuilder.append(this.separator);
            }
            if ((string = stringArray[i]) == null) continue;
            if (this.quotechar != '\u0000') {
                stringBuilder.append(this.quotechar);
            }
            stringBuilder.append(this.stringContainsSpecialCharacters(string) ? this.processLine(string) : string);
            if (this.quotechar == '\u0000') continue;
            stringBuilder.append(this.quotechar);
        }
        stringBuilder.append(this.lineEnd);
        this.pw.write(stringBuilder.toString());
    }

    private boolean stringContainsSpecialCharacters(String string) {
        return string.indexOf(this.quotechar) != -1 || string.indexOf(this.escapechar) != -1;
    }

    protected StringBuilder processLine(String string) {
        StringBuilder stringBuilder = new StringBuilder(128);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (this.escapechar != '\u0000' && c2 == this.quotechar) {
                stringBuilder.append(this.escapechar).append(c2);
                continue;
            }
            if (this.escapechar != '\u0000' && c2 == this.escapechar) {
                stringBuilder.append(this.escapechar).append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder;
    }

    public void flush() throws IOException {
        this.pw.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.pw.close();
        this.rawWriter.close();
    }

    public boolean checkError() {
        return this.pw.checkError();
    }

    public void setResultService(ResultSetHelper resultSetHelper) {
        this.resultService = resultSetHelper;
    }

    public void write(CSVWriteProc cSVWriteProc) {
        cSVWriteProc.process(this);
    }
}

