/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.IOException;
import java.util.ArrayList;

public class CSVParser {
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private String pending;
    private boolean inField = false;
    private final boolean ignoreLeadingWhiteSpace;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final int INITIAL_READ_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    public static final boolean DEFAULT_STRICT_QUOTES = false;
    public static final boolean DEFAULT_IGNORE_LEADING_WHITESPACE = true;
    public static final char NULL_CHARACTER = '\u0000';

    public CSVParser() {
        this(',', '\"', '\\');
    }

    public CSVParser(char c2) {
        this(c2, '\"', '\\');
    }

    public CSVParser(char c2, char c3) {
        this(c2, c3, '\\');
    }

    public CSVParser(char c2, char c3, char c4) {
        this(c2, c3, c4, false);
    }

    public CSVParser(char c2, char c3, char c4, boolean bl) {
        this(c2, c3, c4, bl, true);
    }

    public CSVParser(char c2, char c3, char c4, boolean bl, boolean bl2) {
        if (this.anyCharactersAreTheSame(c2, c3, c4)) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        if (c2 == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        this.separator = c2;
        this.quotechar = c3;
        this.escape = c4;
        this.strictQuotes = bl;
        this.ignoreLeadingWhiteSpace = bl2;
    }

    private boolean anyCharactersAreTheSame(char c2, char c3, char c4) {
        return this.isSameCharacter(c2, c3) || this.isSameCharacter(c2, c4) || this.isSameCharacter(c3, c4);
    }

    private boolean isSameCharacter(char c2, char c3) {
        return c2 != '\u0000' && c2 == c3;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public String[] parseLineMulti(String string) throws IOException {
        return this.parseLine(string, true);
    }

    public String[] parseLine(String string) throws IOException {
        return this.parseLine(string, false);
    }

    private String[] parseLine(String string, boolean bl) throws IOException {
        if (!bl && this.pending != null) {
            this.pending = null;
        }
        if (string == null) {
            if (this.pending != null) {
                String string2 = this.pending;
                this.pending = null;
                return new String[]{string2};
            }
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(128);
        boolean bl2 = false;
        if (this.pending != null) {
            stringBuilder.append(this.pending);
            this.pending = null;
            bl2 = true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == this.escape) {
                if (!this.isNextCharacterEscapable(string, bl2 || this.inField, i)) continue;
                stringBuilder.append(string.charAt(i + 1));
                ++i;
                continue;
            }
            if (c2 == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(string, bl2 || this.inField, i)) {
                    stringBuilder.append(string.charAt(i + 1));
                    ++i;
                } else {
                    if (!this.strictQuotes && i > 2 && string.charAt(i - 1) != this.separator && string.length() > i + 1 && string.charAt(i + 1) != this.separator) {
                        if (this.ignoreLeadingWhiteSpace && stringBuilder.length() > 0 && this.isAllWhiteSpace(stringBuilder)) {
                            stringBuilder.setLength(0);
                        } else {
                            stringBuilder.append(c2);
                        }
                    }
                    bl2 = !bl2;
                }
                this.inField = !this.inField;
                continue;
            }
            if (c2 == this.separator && !bl2) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                this.inField = false;
                continue;
            }
            if (this.strictQuotes && !bl2) continue;
            stringBuilder.append(c2);
            this.inField = true;
        }
        if (bl2) {
            if (bl) {
                stringBuilder.append("\n");
                this.pending = stringBuilder.toString();
                stringBuilder = null;
            } else {
                throw new IOException("Un-terminated quoted field at end of CSV line");
            }
        }
        if (stringBuilder != null) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isNextCharacterEscapedQuote(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && string.charAt(n + 1) == this.quotechar;
    }

    protected boolean isNextCharacterEscapable(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && (string.charAt(n + 1) == this.quotechar || string.charAt(n + 1) == this.escape);
    }

    protected boolean isAllWhiteSpace(CharSequence charSequence) {
        boolean bl = true;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            if (Character.isWhitespace(c2)) continue;
            return false;
        }
        return bl;
    }
}

