/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.CSVReadProc;
import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVRuntimeException;
import au.com.bytecode.opencsv.CSVWriteProc;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class CSV {
    private final char separator;
    private final char quotechar;
    private final char escapechar;
    private final Charset charset;
    private final String lineEnd;
    private final int skipLines;
    private final boolean strictQuotes;
    private final boolean ignoreLeadingWhiteSpace;

    private CSV(char c2, char c3, char c4, String string, int n, boolean bl, boolean bl2, Charset charset) {
        this.separator = c2;
        this.quotechar = c3;
        this.escapechar = c4;
        this.lineEnd = string;
        this.skipLines = n;
        this.strictQuotes = bl;
        this.ignoreLeadingWhiteSpace = bl2;
        this.charset = charset;
    }

    private CSV() {
        this(',', '\"', '\\', "\n", 0, false, true, Charset.defaultCharset());
    }

    public CSVWriter writer(Writer writer) {
        return new CSVWriter(writer, this.separator, this.quotechar, this.escapechar, this.lineEnd);
    }

    public CSVWriter writer(OutputStream outputStream) {
        return this.writer(new OutputStreamWriter(outputStream, this.charset));
    }

    public CSVWriter writer(File file) {
        try {
            return this.writer(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CSVRuntimeException(fileNotFoundException);
        }
    }

    public CSVWriter writer(String string) {
        return this.writer(new File(string));
    }

    public void write(Writer writer, CSVWriteProc cSVWriteProc) {
        this.write(this.writer(writer), cSVWriteProc);
    }

    public void write(OutputStream outputStream, CSVWriteProc cSVWriteProc) {
        this.write(this.writer(outputStream), cSVWriteProc);
    }

    public void write(String string, CSVWriteProc cSVWriteProc) {
        this.write(new File(string), cSVWriteProc);
    }

    public void write(CSVWriter cSVWriter, CSVWriteProc cSVWriteProc) {
        cSVWriter.write(cSVWriteProc);
    }

    public void write(File file, CSVWriteProc cSVWriteProc) {
        this.writeAndClose(this.writer(file), cSVWriteProc);
    }

    public void writeAndClose(Writer writer, CSVWriteProc cSVWriteProc) {
        this.writeAndClose(this.writer(writer), cSVWriteProc);
    }

    public void writeAndClose(OutputStream outputStream, CSVWriteProc cSVWriteProc) {
        this.writeAndClose(this.writer(outputStream), cSVWriteProc);
    }

    public void writeAndClose(CSVWriter cSVWriter, CSVWriteProc cSVWriteProc) {
        try {
            cSVWriter.write(cSVWriteProc);
        }
        catch (RuntimeException runtimeException) {
            try {
                cSVWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw runtimeException;
        }
        try {
            cSVWriter.close();
        }
        catch (Exception exception) {
            throw new CSVRuntimeException(exception);
        }
    }

    public CSVReader reader(Reader reader) {
        return new CSVReader(reader, this.separator, this.quotechar, this.escapechar, this.skipLines, this.strictQuotes, this.ignoreLeadingWhiteSpace);
    }

    public CSVReader reader(InputStream inputStream) {
        return this.reader(new InputStreamReader(inputStream, this.charset));
    }

    public CSVReader reader(File file) {
        try {
            return this.reader(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new CSVRuntimeException(iOException);
        }
    }

    public CSVReader reader(String string) {
        return this.reader(new File(string));
    }

    public void read(InputStream inputStream, CSVReadProc cSVReadProc) {
        this.read(this.reader(inputStream), cSVReadProc);
    }

    public void read(Reader reader, CSVReadProc cSVReadProc) {
        this.read(this.reader(reader), cSVReadProc);
    }

    public void read(File file, CSVReadProc cSVReadProc) {
        this.readAndClose(this.reader(file), cSVReadProc);
    }

    public void read(String string, CSVReadProc cSVReadProc) {
        this.read(new File(string), cSVReadProc);
    }

    public void read(CSVReader cSVReader, CSVReadProc cSVReadProc) {
        cSVReader.read(cSVReadProc);
    }

    public void readAndClose(InputStream inputStream, CSVReadProc cSVReadProc) {
        this.readAndClose(this.reader(inputStream), cSVReadProc);
    }

    public void readAndClose(Reader reader, CSVReadProc cSVReadProc) {
        this.readAndClose(this.reader(reader), cSVReadProc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAndClose(CSVReader cSVReader, CSVReadProc cSVReadProc) {
        try {
            this.read(cSVReader, cSVReadProc);
        }
        finally {
            try {
                cSVReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static CSV create() {
        return new CSV();
    }

    public static Builder separator(char c2) {
        return new Builder().separator(c2);
    }

    public static Builder quote(char c2) {
        return new Builder().quote(c2);
    }

    public static Builder noQuote() {
        return new Builder().noQuote();
    }

    public static Builder escape(char c2) {
        return new Builder().escape(c2);
    }

    public static Builder noEscape() {
        return new Builder().noEscape();
    }

    public static Builder lineEnd(String string) {
        return new Builder().lineEnd(string);
    }

    public static Builder skipLines(int n) {
        return new Builder().skipLines(n);
    }

    public static Builder strictQuotes() {
        return new Builder().strictQuotes();
    }

    public static Builder notStrictQuotes() {
        return new Builder().notStrictQuotes();
    }

    public static Builder ignoreLeadingWhiteSpace() {
        return new Builder().ignoreLeadingWhiteSpace();
    }

    public static Builder notIgnoreLeadingWhiteSpace() {
        return new Builder().notIgnoreLeadingWhiteSpace();
    }

    public static Builder charset(Charset charset) {
        return new Builder().charset(charset);
    }

    public static Builder charset(String string) {
        return new Builder().charset(string);
    }

    public static class Builder {
        private final CSV csv;

        private Builder() {
            this.csv = new CSV();
        }

        private Builder(CSV cSV) {
            this.csv = cSV;
        }

        public CSV create() {
            return this.csv;
        }

        public Builder separator(char c2) {
            return new Builder(new CSV(c2, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        public Builder quote(char c2) {
            return new Builder(new CSV(this.csv.separator, c2, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        public Builder escape(char c2) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, c2, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        public Builder lineEnd(String string) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, string, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        public Builder skipLines(int n) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, n, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        private Builder setStrictQuotes(boolean bl) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, bl, this.csv.ignoreLeadingWhiteSpace, this.csv.charset));
        }

        private Builder setIgnoreLeadingWhiteSpace(boolean bl) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, bl, this.csv.charset));
        }

        public Builder charset(Charset charset) {
            return new Builder(new CSV(this.csv.separator, this.csv.quotechar, this.csv.escapechar, this.csv.lineEnd, this.csv.skipLines, this.csv.strictQuotes, this.csv.ignoreLeadingWhiteSpace, charset));
        }

        public Builder noQuote() {
            return this.quote('\u0000');
        }

        public Builder noEscape() {
            return this.escape('\u0000');
        }

        public Builder strictQuotes() {
            return this.setStrictQuotes(true);
        }

        public Builder notStrictQuotes() {
            return this.setStrictQuotes(false);
        }

        public Builder ignoreLeadingWhiteSpace() {
            return this.setIgnoreLeadingWhiteSpace(true);
        }

        public Builder notIgnoreLeadingWhiteSpace() {
            return this.setIgnoreLeadingWhiteSpace(false);
        }

        public Builder charset(String string) {
            return this.charset(Charset.forName(string));
        }
    }
}

